<?php

////////////////////////////////////////////////////////
// SEND A TEST E-MAIL //////////////////////////////////
////////////////////////////////////////////////////////

function pcma_test_mail_settings() {
	if(!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'lcwp_ajax')) {
        wp_die('Cheating?');
    }
    
	if(!isset($_POST['pcma_mail']) || !filter_var($_POST['pcma_mail'], FILTER_VALIDATE_EMAIL)) {
        wp_die('Insert a valid e-mail');
    }
	$mail = $_POST['pcma_mail'];
	
	// template?
	$template_id = (isset($_POST['template_id'])) ? (int)$_POST['template_id'] : false;

    
    ini_set('display_errors', 1);
	ini_set('display_startup_errors', 1);
	error_reporting(E_ALL);	
	
	$txt = 'Hello,
this is a demo e-mail sent by PrivateContent.
	
Lorem ipsum dolor sit amet, consectetur adipisici elit, sed eiusmod tempor incidunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquid ex ea commodi consequat. Quis aute iure reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint obcaecat cupiditat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.';
	
    if($template_id) {
        $txt = nl2br($txt);    
    }
    
	$txt = pcma_apply_mail_templates($template_id, $txt);
	$result = pcma_send_mail(get_bloginfo('name'), $mail, 'PrivateContent Mail Actions - demo e-mail', $txt);
	
	echo ($result) ? __('E-mail sent successfully', PCMA_ML) : __('An error occurred sending the e-mail', PCMA_ML) .': '. $GLOBALS['pcma_wp_mail_error'];
	wp_die();
}
add_action('wp_ajax_pcma_test_mail_settings', 'pcma_test_mail_settings');






/////////////////////////////////////////////////////////
// TEST E-MAIL STRUCTURE SPECIFYING TEXTS AND TEMPLATE //
/////////////////////////////////////////////////////////

function pcma_send_test_email() {
	if(!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'lcwp_nonce')) {
        wp_die('Cheating?');
    }
    
    
    // data gather and validation
    $fields = array(
        'receiver'      => 'Receiver',
        'title'         => 'Title',
        'contents'      => 'Contents',
        'template_id'   => 'Template ID'
    );
    $fdata = array();

    foreach($fields as $f_id => $f_name) {
        if(!isset($_POST[$f_id])) {
            wp_die($f_name .' missing');
        }
        $fdata[$f_id] = stripslashes($_POST[$f_id]);    
    }
    
    foreach($fdata as $f_id => $val) {
        if($f_id != 'template_id' && empty($val)) {
            wp_die($fields[$f_id] .' is empty');
        }
    }
    
    if(!filter_var($fdata['receiver'], FILTER_VALIDATE_EMAIL)) {
        wp_die('Please use a valid e-mail address');    
    }
    
    // send
	$txt = pcma_apply_mail_templates((int)$fdata['template_id'], $fdata['contents']);
	$result = pcma_send_mail($fdata['receiver'], $fdata['receiver'], '[demo] '. $fdata['title'], $txt);
	
	echo ($result) ? 'success' : __('An error occurred sending the e-mail', PCMA_ML) .': '. $GLOBALS['pcma_wp_mail_error'];
	wp_die();
}
add_action('wp_ajax_pcma_send_test_email', 'pcma_send_test_email');






////////////////////////////////////////////////////////
// PREPARE E-MAIL PREVIEW BY SAVING THE TRANSIENT //////
////////////////////////////////////////////////////////

function pcma_prepare_mail_preview() {
	if(!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'lcwp_nonce')) {
        wp_die('Cheating?');
    }
    
    $fields = array(
        'ts_name'     => 'Transient name',
        'contents'    => 'Contents',
        'template_id' => 'Template ID'
    );
    $fdata = array();

    foreach($fields as $f_id => $f_name) {
        if(!isset($_POST[$f_id])) {
            wp_die($f_name .' missing');
        }
        $fdata[$f_id] = stripslashes($_POST[$f_id]);    
    }
    
    if(strpos(strtolower($fdata['contents']), '<html') === false) {
        $fdata['contents'] = '<html><body>'. wpautop($fdata['contents']) .'</body></html>';
    }
    
    $ts_val = array(
        'contents' => $fdata['contents'],
        'template_id' => (int)$fdata['template_id'],
    );
    
    $response = set_transient($fdata['ts_name'], $ts_val, DAY_IN_SECONDS);
    wp_die('success');
}
add_action('wp_ajax_pcma_prepare_mail_preview', 'pcma_prepare_mail_preview');






////////////////////////////////////////////////////////
// MANUALLY VALIDATE USER GROUPS ///////////////////////
////////////////////////////////////////////////////////

function pcma_mv_group_manual() {
	global $pc_users;
	
	if(!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'lcwp_ajax')) {
        wp_die('Cheating?');
    }
	
	if(!isset($_POST['pcma_cat'])) {
        wp_die('Category is missing');
    }
	$ucat = addslashes(trim($_POST['pcma_cat']));
	
	$args = array(
		'status' 	=> 1,
		'limit'		=> -1,
		'to_get' 	=> array('page_id', 'email'),
		'search' 	=> array(
            array(array('key'=>'email', 'operator'=>'!=', 'val'=>''))
        ),
	);
	
	if($ucat != 'all') {
		$args['categories'] = (int)$ucat;
	}
	$users = $pc_users->get_users($args);
	
	// validate
	foreach($users as $data) {
		if(!empty($data['email'])) {
			update_post_meta($data['page_id'], 'pcma_is_verified', 1);
		}
	}
	
	echo 'success';
	wp_die();
}
add_action('wp_ajax_pcma_mv_group_manual', 'pcma_mv_group_manual');







////////////////////////////////////////////////////////
// MANUALLY VALIDATE SINGLE USER ///////////////////////
////////////////////////////////////////////////////////

function pcma_mv_manual() {
	global $pc_users;

    if(!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'lcwp_nonce')) {
        wp_die('Cheating?');
    }
	if(!isset($_POST['pcma_uid']) || !filter_var($_POST['pcma_uid'], FILTER_VALIDATE_INT)) {
        die('ID is missing');
    }
	$uid = (int)$_POST['pcma_uid'];
	
	// get user page id
	$pag_id = $pc_users->get_user_field($uid, 'page_id');
	
	// validate
	update_post_meta($pag_id, 'pcma_is_verified', 1);
	
	echo 'success';
	wp_die();
}
add_action('wp_ajax_pcma_mv_manual', 'pcma_mv_manual');






////////////////////////////////////////////////////////
// MANUALLY DELETE SINGLE USER VALIDATION //////////////
////////////////////////////////////////////////////////

function pcma_del_mv_manual() {
	global $pc_users;
	
    if(!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'lcwp_nonce')) {
        wp_die('Cheating?');
    }
	if(!isset($_POST['pcma_uid']) || !filter_var($_POST['pcma_uid'], FILTER_VALIDATE_INT)) {
        die('user ID is missing');
    }
	$uid = (int)$_POST['pcma_uid'];

	// get user page id
	$pag_id = $pc_users->get_user_field($uid, 'page_id');
	
	// validate
	delete_post_meta($pag_id, 'pcma_is_verified');
	
	echo 'success';
	wp_die();
}
add_action('wp_ajax_pcma_del_mv_manual', 'pcma_del_mv_manual');






////////////////////////////////////////////////////////
// SEND MANUALLY SINGLE USER VALIDATION E-MAIL /////////
////////////////////////////////////////////////////////

function pcma_manual_send_vmail() {
    if(!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'lcwp_nonce')) {
        wp_die('Cheating?');
    }
    
	include_once(PCMA_DIR .'/integrations.php');
	global $pc_users;
	
	if(!isset($_POST['pcma_uid']) || !filter_var($_POST['pcma_uid'], FILTER_VALIDATE_INT)) {
        die('user ID is missing');
    }
	$uid = (int)$_POST['pcma_uid'];
	
	// send
	$GLOBALS['pcma_force_mail_verif_sending'] = true;
	pcma_mail_verif::send_mail_verif($uid);
	
	echo 'success';
	wp_die();
}
add_action('wp_ajax_pcma_manual_send_vmail', 'pcma_manual_send_vmail');







////////////////////////////////////////////////////////
// SEND MANUALLY GROUP USER VALIDATION E-MAIL /////////
////////////////////////////////////////////////////////

function pcma_group_manual_send_vmail() {
	include_once(PCMA_DIR . '/integrations.php');
	global $pc_users;
	
	if(!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'lcwp_ajax')) {
        wp_die('Cheating?');
    }
	
	if(!isset($_POST['pcma_cat'])) {
        wp_die('Category is missing');
    }
	$ucat = addslashes(trim($_POST['pcma_cat']));
	
	$args = array(
		'status' => 1,
		'to_get' => array('id', 'name', 'surname', 'username', 'email', 'tel', 'psw', 'categories', 'status', 'page_id'),
		'search' => array(
            array(array('key'=>'email', 'operator'=>'!=', 'val'=>''))
        ),
	);
	
	if($ucat != 'all') {
		$args['categories'] = (int)$ucat;
	}
	$users = $pc_users->get_users($args);
	
	$GLOBALS['pcma_force_mail_verif_sending'] = true;
	
	// validate
	foreach($users as $data) {
		if(!empty($data['email']) && get_post_meta($data['page_id'], 'pcma_is_verified', true) != 1) {
			pcma_mail_verif::send_mail_verif($data['id'], $data['page_id'], $data);
		}
	}
	
	echo 'success';
	wp_die();
}
add_action('wp_ajax_pcma_group_manual_send_vmail', 'pcma_group_manual_send_vmail');






//////////////////////////////////////////////////////////////////////////////






////////////////////////////////////////////////////////
// MAIL TEMPLATES - GET TEMPLATES FOR SETTINGS /////////
////////////////////////////////////////////////////////

function pcma_settings_get_mail_templates() {
	if(!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'lcwp_ajax')) {wp_die('Cheating?');}
	
	echo json_encode(pcma_get_mail_templates());
	wp_die();
}
add_action('wp_ajax_pcma_settings_get_mail_templates', 'pcma_settings_get_mail_templates');






////////////////////////////////////////////////////////
// MAIL TEMPLATES - GET TEMPLATE DATA //////////////////
////////////////////////////////////////////////////////

function pcma_get_template_data() {
	if(!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'lcwp_ajax')) {
		echo json_encode(array(
			'status' 	=> 'error',
			'message'	=> 'Cheating?', 
		));
		wp_die();
	}
	
	if(!isset($_POST['template_id']) || !(int)$_POST['template_id']) {
		echo json_encode(array(
			'status' 	=> 'error',
			'message'	=> esc_attr__('Missing template ID', PCMA_ML) 
		));
		wp_die();
	}
	
	
	$data = get_term_by('id', (int)$_POST['template_id'], 'pcma_mail_templates');
	
	if(!$data) {
		json_encode(array(
			'status'=>'error',
			'message' => esc_html__('Template not found', PCMA_ML)
		));
		wp_die();
	} 
	else {	
		wp_die(json_encode(array(
			'status'	=> 'success', 
			'title' 	=> $data->name,
			'code'		=> base64_decode($data->description),
		)));
	}		
}
add_action('wp_ajax_pcma_get_template_data', 'pcma_get_template_data');






////////////////////////////////////////////////////////
// MAIL TEMPLATES - STORE TEMPLATE PREVIEW /////////////
////////////////////////////////////////////////////////

function pcma_store_mail_template_preview() {
	if(!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'lcwp_ajax')) {
		wp_die('Cheating?');
	}
	
	if(!isset($_POST['code'])) {
		wp_die('empty contents');	
	}
	if(!isset($_POST['preview_id']) || empty($_POST['preview_id'])) {
		wp_die('missing preview ID');	
	}
	
	$transient_name = 'pcma_mail_template_preview_'. $_POST['preview_id'];
	set_transient($transient_name, stripslashes((string)$_POST['code']), DAY_IN_SECONDS);
	wp_die('success');
}
add_action('wp_ajax_pcma_store_mail_template_preview', 'pcma_store_mail_template_preview');






////////////////////////////////////////////////////////
// MAIL TEMPLATES - SAVE TEMPLATE //////////////////////
////////////////////////////////////////////////////////

function pcma_save_mail_template() {
	if(!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'lcwp_ajax')) {
		echo json_encode(array(
			'status' 	=> 'error',
			'message'	=> 'Cheating?', 
		));
		wp_die();
	}
	
	if(!isset($_POST['template_id']) || !isset($_POST['code']) || empty($_POST['code']) || !isset($_POST['title']) || empty($_POST['title'])) {
		echo json_encode(array(
			'status' 	=> 'error',
			'message'	=> esc_attr__('Please insert template title and contents', PCMA_ML) 
		));
		wp_die();
	}
	
	
	$template_id = (int)$_POST['template_id'];
	$title 	= stripslashes($_POST['title']);
	$code 	= stripslashes($_POST['code']);
	
	if(strpos($code, '%CONTENT%') === false) {
		echo json_encode(array(
			'status' 	=> 'error',
			'message'	=> esc_attr__('Template must contain the %CONTENT% placeholder', PCMA_ML) 
		));
		wp_die();
	}
	$code 	= base64_encode($code);
	
	
	// empty template ID - create new one
	if(!$template_id) {
		$resp = wp_insert_term($title, 'pcma_mail_templates', array(
			'slug'			=> sanitize_title($title), 
			'description' 	=> $code,
		));	
		
		if(is_array($resp)) {
			wp_die(json_encode(array(
				'status'		=> 'success', 
				'template_id' 	=> $resp['term_id']
			)));
		}
		else {
			$err_mes = $resp->errors['term_exists'][0];
			wp_die(json_encode(array(
				'status' =>'error', 
				'message' => $err_mes
			 )));
		}	
	}
	
	// update existing template
	else {
		$args = array(
			'name' 	=> $title ,
			'slug'	=> sanitize_title($title),
			'description' => $code,
		);
		$resp = wp_update_term($template_id, 'pcma_mail_templates', $args);
		
		if(is_wp_error($resp)) {
			json_encode(array(
				'status'=>'error',
				'message' => $err_mes
			));
			wp_die();
		} 
		else {	
			wp_die(json_encode(array(
				'status'		=> 'success', 
				'template_id' 	=> $template_id,
			)));
		}		
	}
	
	wp_die();
}
add_action('wp_ajax_pcma_save_mail_template', 'pcma_save_mail_template');






////////////////////////////////////////////////////////
// MAIL TEMPLATES - DELETE TEMPLATE ////////////////////
////////////////////////////////////////////////////////

function pcma_del_mail_template() {
	if(!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'lcwp_ajax')) {
		wp_die('Cheating?');
	}

	if(!isset($_POST['template_id']) || !(int)$_POST['template_id']) {
		wp_die('missing template ID');	
	}
	$resp = wp_delete_term( (int)$_POST['template_id'], 'pcma_mail_templates');

	if($resp == '1') {wp_die('success');}
	else {wp_die('error during template deletion');}
}
add_action('wp_ajax_pcma_del_mail_template', 'pcma_del_mail_template');






//////////////////////////////////////////////////////////////////////////////






////////////////////////////////////////////////////////
// EMAIL CAMPAIGNS - NEW ATTACHMENTS CODE //////////////
////////////////////////////////////////////////////////

function pcma_ecb_new_attach_code() {
	if(!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'lcwp_nonce')) {
		wp_die(json_encode(array(
            'status'=> 'error',
            'mess'  =>'Cheating?'
        )));
	}
    
    if(!isset($_POST['campaign_id']) || !(int)$_POST['campaign_id']) {
        wp_die(json_encode(array(
            'status'=> 'error',
            'mess'  => __('Campaign ID missing', PCMA_ML)
        )));        
    }

    if(!isset($_POST['new_files'])) {
        wp_die(json_encode(array(
            'status'=> 'error',
            'mess'  => __('New files missing', PCMA_ML)
        )));        
    }
    $new_files = (array)$_POST['new_files'];
    
    
    $codes = array();
    foreach($new_files as $file_id) {
        $codes[ (int)$file_id ] = pcma_email_campaigns::admin_builder_attach_code($file_id, (int)$_POST['campaign_id']);
    }
    
    wp_die(json_encode(array(
        'status'=> 'success',
        'codes' => $codes
    )));
}
add_action('wp_ajax_pcma_ecb_new_attach_code', 'pcma_ecb_new_attach_code');






/////////////////////////////////////////////////////
// EMAIL CAMPAIGNS - DYNAMIC USERS SEARCH ///////////
/////////////////////////////////////////////////////

function pcma_ecb_users_search() {
	if (!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'lcwp_nonce')) {
        die('Cheating?');
    }
	global $pc_users;
	
	if(!isset($_POST['search'])) {
		echo json_encode( array() );
		wp_die();
	}
	$search = trim( $_POST['search']);
	
	$args = array(
		'limit' => -1,
		'to_get' => array('id', 'username', 'name', 'surname', 'email'),
		'search' => array(
            array(
                'relation' => 'AND',
                array('key'=>'email', 'operator'=>'!=', 'val'=>''),
            ),
            array(
                'relation' => 'OR',
                array('key'=>'username', 'operator'=>'LIKE', 'val'=>'%'. $search .'%'),
                array('key'=>'name',     'operator'=>'LIKE', 'val'=>'%'. $search .'%'),
                array('key'=>'surname',  'operator'=>'LIKE', 'val'=>'%'. $search .'%'),
                array('key'=>'email',    'operator'=>'LIKE', 'val'=>'%'. $search .'%')
            ),
		),
		'custom_search' => 'AND status = 1 AND email != ""'
	);
	
    
    // exclude already selected ones
    if(isset($_POST['to_exclude']) && is_array($_POST['to_exclude']) && !empty($_POST['to_exclude'])) {
        $args['custom_search'] .= 'AND id NOT IN('. implode(',', $_POST['to_exclude']) .')';     
    }
    
    // check wp user editing rights
    $pc_cats_for_curr_user = pc_wpuc_static::get_wp_user_editable_pc_cats();  
    if($pc_cats_for_curr_user != 'any') {
        $args['custom_search'] .= ' AND '. $pc_users->categories_query($pc_cats_for_curr_user);   
    }

    // query
	$users = $pc_users->get_users($args);
	$to_return = array();
    
	foreach($users as $ud) {	
		$nicename = (!empty($ud['name']) && !empty($ud['surname'])) ? 
				trim($ud['name'].' '.$ud['surname']).' ('.$ud['username'].' - '.$ud['email'].')' : 
				$ud['username'] .' - '.$ud['email'];
		
		$to_return[] = array(
			'id'	=> $ud['id'], 
			'value'	=> '', 
			'label'	=> $nicename
		);	
        
        
        // PCMA-FILTER - Allows e-mail campaigns manual receivers array management (autocomplete ajax) 
        $to_return = (array)apply_filters('pcma_ec_aa_user_array', $to_return);
	}
    
    if(empty($to_return)) {
        $to_return[] = array(
			'id'	=> 0, 
			'value'	=> '', 
			'label'	=> __('no users found', PCMA_ML) .'..'
		);	        
    }
	
	echo json_encode($to_return);
	wp_die();
}
add_action('wp_ajax_pcma_ecb_users_search', 'pcma_ecb_users_search');






////////////////////////////////////////////////////////
// EMAIL CAMPAIGNS - LIST PVTCONTENT RECEIVERS /////////
////////////////////////////////////////////////////////

function pcma_ecb_list_receivers() {
	if(!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'lcwp_nonce')) {
		wp_die(json_encode(array(
            'status'=> 'error',
            'mess'  =>'Cheating?'
        )));
	}
    
    include_once(PC_DIR .'/classes/simple_form_validator.php');
    $validator = new simple_fv;
    
    $indexes = array();
    $indexes[] = array('index'=>'pcma_ecb_include_pc_cats', 'label'=>'Targeted user categories');
    $indexes[] = array('index'=>'pcma_ecb_exclude_pc_cats', 'label'=>'Excluded user categories');
    $indexes[] = array('index'=>'pcma_ecb_incl_disabled_users', 'label'=>'Include disabled users?');
    
    $indexes[] = array('index'=>'pcma_ecb_auf_f', 'label'=>'User filters - fields');
    $indexes[] = array('index'=>'pcma_ecb_auf_cond', 'label'=>'User filters - conditions');
    $indexes[] = array('index'=>'pcma_ecb_auf_val', 'label'=>'User filters - values');
    $indexes[] = array('index'=>'pcma_ecb_auf_operator', 'label'=>'User filters - operator');
    
    $indexes[] = array('index'=>'pcma_ecb_extra_user_ids', 'label'=>'Extra user IDs');
    
    $validator->formHandle($indexes);
    $fdata = $validator->form_val;
    $error = $validator->getErrors();
    
    
    if(empty($fdata['pcma_ecb_include_pc_cats'])) {
        wp_die(json_encode(array(
            'status'=> 'error',
            'mess'  => __('No receiver categories selected', PCMA_ML)
        )));    
    }    
    
    
    $fdata['pcma_ecb_user_filters'] = array();
    
    if(!empty($fdata['pcma_ecb_include_pc_cats']) && !empty($fdata['pcma_ecb_auf_f'])) {
        if(count((array)$fdata['pcma_ecb_auf_f']) != count((array)$fdata['pcma_ecb_auf_cond']) || count((array)$fdata['pcma_ecb_auf_f']) != count((array)$fdata['pcma_ecb_auf_val'])) {
            
            wp_die(json_encode(array(
                'status'=> 'error',
                'mess'  => 'User filters - elements do not have the same number of values'
            )));
        }
        
        else {
            for($a=0; $a < count((array)$fdata['pcma_ecb_auf_f']); $a++) {
                
                $fdata['pcma_ecb_user_filters'][] = array(
                    'field' => (string)$fdata['pcma_ecb_auf_f'][$a],
                    'cond'  => (string)$fdata['pcma_ecb_auf_cond'][$a],
                    'val'   => (string)$fdata['pcma_ecb_auf_val'][$a],
                ); 
            }
        }
    }
    
    // clean useless filter indexes
    unset($fdata['pcma_ecb_auf_f']);
    unset($fdata['pcma_ecb_auf_cond']);
    unset($fdata['pcma_ecb_auf_val']);
    
    
    // PCMA-FILTER - manage fields val array passed to count involved campaign users - fields can be fetched through $_POST
    $fdata = apply_filters('pcma_filter_ecb_list_receivers', $fdata);
    
    wp_die(json_encode(array(
        'status'    => 'success',
        'users'     => pcma_email_campaigns::get_involved_users(false, $fdata)
    )));
}
add_action('wp_ajax_pcma_ecb_list_receivers', 'pcma_ecb_list_receivers');






////////////////////////////////////////////////////////
// EMAIL CAMPAIGNS - CHANGE ONGOING CAMPAIGN STATUS ////
////////////////////////////////////////////////////////

function pcma_ecb_change_og_status() {
	if(!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'lcwp_nonce')) {
		wp_die('Cheating?');
	}
    
    if(!isset($_POST['campaign_id']) || !(int)$_POST['campaign_id']) {
        wp_die(__('Campaign ID missing', PCMA_ML));        
    }
    
    if(!isset($_POST['new_status']) || !in_array($_POST['new_status'], array('pause', 'resume'))) {
        wp_die(__('New status missing or not among accepted', PCMA_ML));        
    }
    
    
    if($_POST['new_status'] == 'pause') {
        update_post_meta((int)$_POST['campaign_id'], 'pcma_email_campaign_paused', 1);        
    } else {
        delete_post_meta((int)$_POST['campaign_id'], 'pcma_email_campaign_paused');    
    }
    
    wp_die('success');
}
add_action('wp_ajax_pcma_ecb_change_og_status', 'pcma_ecb_change_og_status');






////////////////////////////////////////////////////////
// EMAIL CAMPAIGNS - CLONE CAMPAIGN ////////////////////
////////////////////////////////////////////////////////

function pcma_clone_campaign() {
	if(!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'lcwp_nonce')) {
		wp_die(json_encode(array(
            'status'=> 'error',
            'mess'  => 'Cheating?'
        )));
	}
    
    if(!isset($_POST['campaign_id']) || !(int)$_POST['campaign_id']) {
        wp_die(json_encode(array(
            'status'=> 'error',
            'mess'  => __('Campaign ID missing', PCMA_ML)
        )));
    }
    
    if(!isset($_POST['new_title']) || empty($_POST['new_title'])) {
        wp_die(json_encode(array(
            'status'=> 'error',
            'mess'  => __('New title missing', PCMA_ML)
        )));    
    }
       
    
    $cmp_id = (int)$_POST['campaign_id'];
    $cmp = get_post($cmp_id);
    if(!$cmp) {
        wp_die(json_encode(array(
            'status'=> 'error',
            'mess'  => __('Campaign not found', PCMA_ML)
        )));     
    }
       

    //// create new post
    $gmt_date = $cmp->post_date_gmt;
    
    // if cloned has got a past date, set it to tomorrow 
    if(strtotime($cmp->post_date_gmt) <= gmdate('U')) {
        $datetime = new DateTime();
        $datetime->modify('+1 day');
        $datetime->setTimezone(new DateTimeZone('GMT'));

        $gmt_date = $datetime->format('Y-m-d H:i:s');
        $gmt_date = substr($gmt_date, 0, -5) . '00:00'; // comply with 5mins span
    }
    
    $new_entry = array();
    $new_entry['post_content']  = $cmp->post_content;
    $new_entry['post_status']   = 'draft';
    $new_entry['post_title']    = stripslashes($_POST['new_title']);
    $new_entry['post_type']     = 'pcma_email_campaigns';
    $new_entry['post_date_gmt'] = $gmt_date;
    $new_entry['post_date']     = get_date_from_gmt($gmt_date, 'Y-m-d H:i:s');
    
    $new_cmp_id = wp_insert_post($new_entry, true);
    if(is_wp_error($new_cmp_id)) {
        
        wp_die(json_encode(array(
            'status'=> 'error',
            'mess'  => __('Error during campaign creation', PCMA_ML) .': '. $new_cmp_id->get_error_message()
        )));    
    }
    
    $metas = array(
        'pcma_ecb_title',
        'pcma_ecb_template',
        'pcma_ecb_attach',
        'pcma_ecb_include_pc_cats',
        'pcma_ecb_exclude_pc_cats',
        'pcma_ecb_incl_disabled_users',
        'pcma_ecb_user_filters',
        'pcma_ecb_auf_operator',
        'pcma_ecb_extra_user_ids',
        'pcma_ecb_extra_emails',
    );
    foreach($metas as $meta) {
        $val = get_post_meta($cmp_id, $meta, true);
        update_post_meta($new_cmp_id, $meta, $val);
    }
       
    
    wp_die(json_encode(array(
        'status'=> 'success',
        'new_cmp_editor_url' => admin_url('post.php?post='. $new_cmp_id .'&action=edit')
    )));
}
add_action('wp_ajax_pcma_clone_campaign', 'pcma_clone_campaign');






///////////////////////////////////////////////////////
//// E-MAILS CENTER - RESET SENT E-MAIL COUNTER ///////
///////////////////////////////////////////////////////


add_action('wp_ajax_pcma_reset_sent_email_counter', function() {
    if(!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'lcwp_nonce')) {
        wp_die('invalid nonce');
    }
    
    $periods = array('hourly', 'daily', 'monthly');
    
    foreach($periods as $p) {
        $target_transient_name = str_replace('%PERIOD%', $p, pcma_email_campaigns::$esipp_transient_name);
        delete_transient($target_transient_name);
    }   
    wp_die('success');
});






//////////////////////////////////////////////////////////////////////////////






////////////////////////////////////////////////////////
// USER PVT PAGE UPDATE NOTIFIER ///////////////////////
////////////////////////////////////////////////////////

function pcma_send_uppu_notif() {
	global $pc_users;
    
    if(!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'lcwp_ajax')) {
        wp_die('Cheating?');
    }
    
    if(!isset($_POST['uid']) || !is_numeric($_POST['uid']) || !$_POST['uid']) {
        wp_die('missing user ID');   
    }
    
    $uid = (int)$_POST['uid'];
    $u_data = $pc_users->get_user($uid, array('to_get' => array('id', 'email', 'name', 'surname', 'username', 'tel', 'psw', 'categories')));
    
    
    
    
    // get user e-mail
    $email = $pc_users->get_user_field($uid, 'email');
    if(empty($u_data['email'])) {
        wp_die(esc_attr__('The user does not have an e-mail', PCMA_ML));  
    }
    
	
    $txt = pcma_apply_mail_templates(get_option('pcma_niu_template'), get_option('pcma_uppu_mail_txt'));
    $txt = pcma_replace_placeholders($uid, $txt, $u_data);
    $txt = str_replace('%PAGE-URL%', get_permalink(get_option('pg_target_page')), $txt);

    $title = pcma_replace_placeholders($uid, get_option('pcma_uppu_mail_subj'), $u_data);
    $result = pcma_send_mail($u_data['username'], $u_data['email'], $title, $txt);
    
    echo ($result) ? 'success' : __('An error occurred sending the e-mail', PCMA_ML) .': '. $GLOBALS['pcma_wp_mail_error'];
	wp_die();
}
add_action('wp_ajax_pcma_send_uppu_notif', 'pcma_send_uppu_notif');






//////////////////////////////////////////////////////////////////////////////






////////////////////////////////////////////////////////
// MANUAL GLOBAL MAILCHIMP SYNC ////////////////////////
////////////////////////////////////////////////////////

function pcma_mc_ajax_sync() {
	if(!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'lcwp_ajax')) {
        wp_die('Cheating?');
    }
    
	include_once(PCMA_DIR .'/classes/mailchimp_integration.php');
	$mc = new pcma_mailchimp();
	
	if(!$mc->is_ready()) {
		wp_die( __('Error connecting to Mailchimp - check API key and list', PCMA_ML) );	
	}
	
	// sync also fields
	if(!$mc->sync_fields()) {
		wp_die(json_encode(array(
			'status' 	=> 0,
			'mess'		=> __('Error syncing custom fields', PCMA_ML) .' '. $mc->call_error
		)));	
	}
    
	
	// perform
	if($mc->subscribe_members('any', true)) {
		wp_die(json_encode(array(
			'status' 	=> 1,
			'mess'		=> $mc->synced_num.' '. __('users synced!', PCMA_ML)
		)));	
	}
	else {
		wp_die(json_encode(array(
			'status' 	=> 0,
			'mess'		=> __('Error syncing users', PCMA_ML) .' '. $mc->call_error
		)));	
	}
	
	wp_die();
}
add_action('wp_ajax_pcma_mc_ajax_sync', 'pcma_mc_ajax_sync');






////////////////////////////////////////////////////////
// MAILCHIMP DISCLAIMER MANAG IN "ADD USER"  PAGE //////
////////////////////////////////////////////////////////

function pcma_mc_add_user_discl_cmd() {
	if(!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'lcwp_nonce')) {
		wp_die('Cheating?');
	}
    
    include_once(PCMA_DIR .'/classes/mailchimp_integration.php');
	$mc = new pcma_mailchimp();
	global $pc_meta;
	
	if(!$mc->is_ready()) {
		wp_die( __('Error connecting to Mailchimp - check API key and list', PCMA_ML) );	
	}
	
	$uid = (int)$_POST['uid'];
	if(empty($uid)) {
		wp_die( __('User ID missing', PCMA_ML) );		
	}
	
	
	if($_POST['cmd'] == 'unsub') {
        $pc_meta->update_meta($uid, 'pcma_mc_disclaimer', '');
        
		if(!$mc->remove_members(array((int)$_POST['uid']))) {
            $pc_meta->update_meta($uid, 'pcma_mc_disclaimer', 1);
            wp_die($mc->call_error);
        }
	}
	
	else {
        $pc_meta->update_meta($uid, 'pcma_mc_disclaimer', 1);	
        
        if(!$mc->subscribe_members(array((int)$_POST['uid']), true)) {
            $pc_meta->update_meta($uid, 'pcma_mc_disclaimer', '');	
            wp_die($mc->call_error);
        }
	}

	wp_die('success');
}
add_action('wp_ajax_pcma_mc_add_user_discl_cmd', 'pcma_mc_add_user_discl_cmd');






////////////////////////////////////////////////////////
// MAILCHIMP DISCLAIMER MANAG IN "ADD USER"  PAGE //////
////////////////////////////////////////////////////////

function pcma_mc_manual_resync() {
	if(!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'lcwp_nonce')) {
		wp_die('Cheating?');
	}
    
    include_once(PCMA_DIR .'/classes/mailchimp_integration.php');
	$mc = new pcma_mailchimp();

	if(!$mc->is_ready()) {
		wp_die( __('Error connecting to Mailchimp - check API key and list', PCMA_ML) );	
	}
	
	$uid = (int)$_POST['uid'];
	if(empty($uid)) {
		wp_die( __('User ID missing', PCMA_ML) );		
	}
	
	if(!$mc->subscribe_members(array((int)$_POST['uid']), true)) {
        wp_die($mc->call_error);
    }
	
	wp_die('success');
}
add_action('wp_ajax_pcma_mc_manual_resync', 'pcma_mc_manual_resync');
